import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_color.dart';
import 'package:viserpay_agent/core/utils/my_images.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/core/utils/style.dart';
import 'package:viserpay_agent/data/controller/auth/forget_password/verify_password_controller.dart';
import 'package:viserpay_agent/data/repo/auth/login_repo.dart';
import 'package:viserpay_agent/data/services/api_service.dart';
import 'package:viserpay_agent/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay_agent/view/components/buttons/gradient_rounded_button.dart';
import 'package:viserpay_agent/view/components/text/default_text.dart';

import '../../../../components/image/custom_svg_picture.dart';
import '../../../../components/otp_field_widget/otp_field_widget.dart';

class VerifyForgetPassScreen extends StatefulWidget {
  const VerifyForgetPassScreen({super.key});

  @override
  State<VerifyForgetPassScreen> createState() => _VerifyForgetPassScreenState();
}

class _VerifyForgetPassScreenState extends State<VerifyForgetPassScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(LoginRepo(apiClient: Get.find()));
    final controller = Get.put(VerifyPasswordController(loginRepo: Get.find()));
    controller.email = Get.arguments;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      child: Scaffold(
          backgroundColor: MyColor.colorWhite,
          appBar: CustomAppBar(
            fromAuth: true,
            isShowBackBtn: true,
            bgColor: MyColor.getAppBarColor(),
            title: MyStrings.passVerification.tr,
          ),
          body: GetBuilder<VerifyPasswordController>(
              builder: (controller) => controller.isLoading
                  ? Center(child: CircularProgressIndicator(color: MyColor.getPrimaryColor()))
                  : SingleChildScrollView(
                      padding: Dimensions.screenPaddingHV,
                      child: Center(
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            const SizedBox(height: Dimensions.space50),
                            Container(
                              height: 100,
                              width: 100,
                              alignment: Alignment.center,
                              decoration: BoxDecoration(color: MyColor.primaryColor.withOpacity(.07), shape: BoxShape.circle),
                              child: CustomSvgPicture(image: MyImages.emailVerifyImage, height: 50, width: 50, color: MyColor.getPrimaryColor()),
                            ),
                            const SizedBox(height: Dimensions.space25),
                            Padding(padding: const EdgeInsets.symmetric(horizontal: 25), child: DefaultText(text: "${MyStrings.verifyPasswordSubText.tr} : ${Converter.maskSensitiveInformation(controller.email)}", textAlign: TextAlign.center, textColor: MyColor.getContentTextColor())),
                            const SizedBox(height: 30),
                            OTPFieldWidget(
                              onChanged: (value) {
                                controller.currentText = value;
                              },
                            ),
                            const SizedBox(height: Dimensions.space30),
                            GradientRoundedButton(
                                showLoadingIcon: controller.verifyLoading,
                                text: MyStrings.verify.tr,
                                press: () {
                                  if (controller.currentText.length != 6) {
                                    controller.hasError = true;
                                  } else {
                                    controller.verifyForgetPasswordCode(controller.currentText);
                                  }
                                }),
                            const SizedBox(height: Dimensions.space25),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                DefaultText(text: MyStrings.didNotReceiveCode.tr, textColor: MyColor.getTextColor()),
                                const SizedBox(width: Dimensions.space5),
                                controller.isResendLoading
                                    ? const SizedBox(
                                        height: 17,
                                        width: 17,
                                        child: CircularProgressIndicator(
                                          color: MyColor.primaryColor,
                                        ),
                                      )
                                    : TextButton(
                                        onPressed: () {
                                          controller.resendForgetPassCode();
                                        },
                                        child: DefaultText(text: MyStrings.resend.tr, textStyle: regularDefault.copyWith(color: MyColor.getPrimaryColor())),
                                      )
                              ],
                            )
                          ],
                        ),
                      )))),
    );
  }
}
